# -*- coding: utf-8 -*-

#EXT_FORCES.PY
#@author: Thomas Gillis
#
#Created on 1/7/2013
#Last update on 9/7/2013
#
#Copyright 2013 Universite Catholique de Louvain

import numpy as np

def user_ExtForces(PxF,RxF,VxF,OMxF,AxF,OMPxF,mbs,tsim,ixF):
    """ Compute the external force for a given force point

    :param PxF: the position of the point
    :param RxF: the rotation matrix of the point
    :param VxF: the velocity vector of the point
    :param OMxF: the ??? of the point
    :param mbs: the Data structure
    :param tsim: the simulation time
    :param ixF: the index of the force point
    
    """
    
    Fx=0.0
    Fy=0.0
    Fz=0.0
    Mx=0.0
    My=0.0
    Mz=0.0
    idpt=mbs.xfidpt[ixF]
    dxF=mbs.dpt[1:,idpt]

    
#==============================================================================
# BEGIN OF USER CODE
#==============================================================================

    # get the force id
    F1 = mbs.extforce_id["LateralBumpstop"]
    
    if ixF == F1:
        gap = 0.3
        if PxF[1] > gap:
            Fx = -10000*(PxF[1]-gap)
    #...

#==============================================================================
# END OF USER CODE
#==============================================================================

    Swr=np.zeros(9+1)
    Swr[1:]=np.r_[Fx,Fy,Fz,Mx,My,Mz,dxF] #concatenation...
    
    return Swr
